<?php

namespace Database\Factories;

use App\Models\LicenseRequirement;
use App\Models\StationLicense;
use App\Models\WellLicense;
use Illuminate\Database\Eloquent\Factories\Factory;

class LicenseRequirementFactory extends Factory
{
    protected $model = LicenseRequirement::class;

    public function definition(): array
    {
        return [
            'licenseable_id' => WellLicense::factory(),
            'licenseable_type' => WellLicense::class,
            'name' => $this->faker->randomElement([
                'Technical Specifications',
                'Environmental Impact Assessment',
                'Site Survey Report',
                'Water Quality Analysis',
                'Community Approval Letter',
                'Land Ownership Certificate',
                'Construction Permits',
                'Safety Compliance Report',
                'Financial Feasibility Study',
                'Maintenance Plan Documentation',
                'Well Disclosure Document',
                'Pump Installation Certificate',
                'Water Sample Analysis Report',
                'Station Design Plans',
                'Environmental Permit',
            ]),
            'status' => $this->faker->randomElement([
                LicenseRequirement::STATUS_PENDING,
                LicenseRequirement::STATUS_ACCEPTED,
                LicenseRequirement::STATUS_REJECTED,
                LicenseRequirement::STATUS_ASK_MODIFICATION,
            ]),
        ];
    }

    /**
     * Indicate that the requirement is for a well license
     */
    public function forWellLicense(): static
    {
        return $this->state(fn (array $attributes) => [
            'licenseable_id' => WellLicense::factory(),
            'licenseable_type' => WellLicense::class,
        ]);
    }

    /**
     * Indicate that the requirement is for a station license
     */
    public function forStationLicense(): static
    {
        return $this->state(fn (array $attributes) => [
            'licenseable_id' => StationLicense::factory(),
            'licenseable_type' => StationLicense::class,
        ]);
    }

    /**
     * Indicate that the requirement is pending
     */
    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => LicenseRequirement::STATUS_PENDING,
        ]);
    }

    /**
     * Indicate that the requirement is accepted
     */
    public function accepted(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => LicenseRequirement::STATUS_ACCEPTED,
        ]);
    }

    /**
     * Indicate that the requirement is rejected
     */
    public function rejected(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => LicenseRequirement::STATUS_REJECTED,
        ]);
    }

    /**
     * Indicate that the requirement needs modification
     */
    public function needsModification(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => LicenseRequirement::STATUS_ASK_MODIFICATION,
        ]);
    }
}
