<?php

namespace Database\Factories;

use App\Models\Initiative;
use App\Models\InitiativeResult;
use Illuminate\Database\Eloquent\Factories\Factory;

class InitiativeResultFactory extends Factory
{
    protected $model = InitiativeResult::class;

    public function definition(): array
    {
        return [
            'initiative_id' => Initiative::factory(),
            'expected_q1' => $this->faker->randomFloat(2, 10, 100),
            'actual_q1' => $this->faker->randomFloat(2, 8, 120),
            'expected_q2' => $this->faker->randomFloat(2, 10, 100),
            'actual_q2' => $this->faker->randomFloat(2, 8, 120),
            'expected_q3' => $this->faker->randomFloat(2, 10, 100),
            'actual_q3' => $this->faker->randomFloat(2, 8, 120),
            'expected_q4' => $this->faker->randomFloat(2, 10, 100),
            'actual_q4' => $this->faker->randomFloat(2, 8, 120),
        ];
    }

    public function exceeding(): static
    {
        return $this->state(fn (array $attributes) => [
            'actual_q1' => $this->faker->randomFloat(2, 110, 150),
            'actual_q2' => $this->faker->randomFloat(2, 110, 150),
            'actual_q3' => $this->faker->randomFloat(2, 110, 150),
            'actual_q4' => $this->faker->randomFloat(2, 110, 150),
        ]);
    }

    public function underperforming(): static
    {
        return $this->state(fn (array $attributes) => [
            'actual_q1' => $this->faker->randomFloat(2, 50, 80),
            'actual_q2' => $this->faker->randomFloat(2, 50, 80),
            'actual_q3' => $this->faker->randomFloat(2, 50, 80),
            'actual_q4' => $this->faker->randomFloat(2, 50, 80),
        ]);
    }

    public function partialData(): static
    {
        return $this->state(fn (array $attributes) => [
            'actual_q3' => null,
            'actual_q4' => null,
        ]);
    }
}
