<?php

namespace Database\Factories;

use App\Models\Initiative;
use App\Models\InitiativeProject;
use Illuminate\Database\Eloquent\Factories\Factory;

class InitiativeProjectFactory extends Factory
{
    protected $model = InitiativeProject::class;

    public function definition(): array
    {
        $names = [
            'Water Filtration System Installation',
            'Community Training Program',
            'Infrastructure Maintenance Phase',
            'Technology Implementation',
            'Quality Monitoring Setup',
            'Emergency Preparedness Training',
            'Environmental Impact Assessment',
            'Stakeholder Engagement Campaign',
            'Technical Capacity Building',
            'Sustainability Planning',
        ];

        return [
            'name' => $this->faker->randomElement($names),
            'weight' => $this->faker->randomFloat(2, 5, 40), // Will be validated by model
            'initiative_id' => Initiative::factory(),
        ];
    }

    public function majorProject(): static
    {
        return $this->state(fn (array $attributes) => [
            'weight' => $this->faker->randomFloat(2, 30, 50),
        ]);
    }

    public function minorProject(): static
    {
        return $this->state(fn (array $attributes) => [
            'weight' => $this->faker->randomFloat(2, 5, 20),
        ]);
    }
}
