<?php

namespace Database\Factories;

use App\Models\Initiative;
use App\Models\PerformanceWallet;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class InitiativeFactory extends Factory
{
    protected $model = Initiative::class;

    public function definition(): array
    {
        $names = [
            'Clean Water Access Expansion',
            'Rural Infrastructure Development',
            'Water Quality Monitoring System',
            'Community Education Program',
            'Emergency Response Network',
            'Sustainable Water Management',
            'Technology Integration Project',
            'Environmental Conservation Initiative',
            'Public Health Water Safety',
            'Regional Cooperation Framework',
        ];

        $startDate = $this->faker->dateTimeBetween('-6 months', '+2 months');
        $endDate = $this->faker->dateTimeBetween($startDate, '+2 years');

        return [
            'name' => $this->faker->randomElement($names),
            'start_date' => $startDate,
            'expected_end_date' => $endDate,
            'description' => $this->faker->paragraph(4),
            'expected_cost' => $this->faker->randomFloat(2, 50000, 2000000),
            'emergency_reserve' => $this->faker->randomFloat(2, 5000, 200000),
            'performance_wallet_id' => PerformanceWallet::factory(),
            'created_by' => User::factory(),
        ];
    }

    public function lowBudget(): static
    {
        return $this->state(fn (array $attributes) => [
            'expected_cost' => $this->faker->randomFloat(2, 10000, 100000),
            'emergency_reserve' => $this->faker->randomFloat(2, 1000, 10000),
        ]);
    }

    public function highBudget(): static
    {
        return $this->state(fn (array $attributes) => [
            'expected_cost' => $this->faker->randomFloat(2, 500000, 5000000),
            'emergency_reserve' => $this->faker->randomFloat(2, 50000, 500000),
        ]);
    }

    public function ongoing(): static
    {
        return $this->state(fn (array $attributes) => [
            'start_date' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'expected_end_date' => $this->faker->dateTimeBetween('now', '+1 year'),
        ]);
    }

    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'start_date' => $this->faker->dateTimeBetween('-1 year', '-6 months'),
            'expected_end_date' => $this->faker->dateTimeBetween('-3 months', 'now'),
        ]);
    }
}
