<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\ExchangeRequest>
 */
class ExchangeRequestFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'status' => \App\Models\ExchangeRequest::STATUS_CREATED,
            'completion_report_id' => \App\Models\CompletionReport::factory(),
            'created_by' => \App\Models\User::factory(),
            'transaction_date' => fake()->dateTimeBetween('-1 month', 'now'),
        ];
    }
}
