<?php

namespace Database\Factories;

use App\Models\DonorFinancialPortfolio;
use Illuminate\Database\Eloquent\Factories\Factory;

class DonorFinancialPortfolioFactory extends Factory
{
    protected $model = DonorFinancialPortfolio::class;

    public function definition(): array
    {
        $portfolioTypes = [
            'Water Access Foundation',
            'Rural Development Fund',
            'Emergency Relief Portfolio',
            'Community Infrastructure Grant',
            'Sustainable Development Initiative',
            'Humanitarian Aid Program',
            'Environmental Conservation Fund',
            'Social Impact Investment',
        ];

        return [
            'name' => $this->faker->randomElement($portfolioTypes).' Portfolio',
            'balance' => $this->faker->randomFloat(2, 100000, 5000000),
            'operating_percentage' => $this->faker->randomFloat(2, 1.5, 15.0),
        ];
    }

    public function largeFund(): static
    {
        return $this->state(fn (array $attributes) => [
            'balance' => $this->faker->randomFloat(2, 2000000, 10000000),
            'operating_percentage' => $this->faker->randomFloat(2, 2.0, 8.0),
        ]);
    }

    public function emergencyFund(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Emergency Relief Portfolio',
            'balance' => $this->faker->randomFloat(2, 500000, 2000000),
            'operating_percentage' => $this->faker->randomFloat(2, 3.0, 12.0),
        ]);
    }

    public function communityFund(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Community Development Fund',
            'balance' => $this->faker->randomFloat(2, 300000, 1500000),
            'operating_percentage' => $this->faker->randomFloat(2, 2.5, 10.0),
        ]);
    }

    public function infrastructureFund(): static
    {
        return $this->state(fn (array $attributes) => [
            'name' => 'Infrastructure Development Grant',
            'balance' => $this->faker->randomFloat(2, 1000000, 5000000),
            'operating_percentage' => $this->faker->randomFloat(2, 1.0, 6.0),
        ]);
    }
}
