<?php

namespace Database\Factories;

use App\Models\Department;
use Illuminate\Database\Eloquent\Factories\Factory;

class DepartmentFactory extends Factory
{
    protected $model = Department::class;

    public function definition(): array
    {
        $departments = [
            'Water Quality Management' => 'Responsible for monitoring and improving water quality standards',
            'Infrastructure Development' => 'Manages construction and maintenance of water infrastructure',
            'Community Engagement' => 'Facilitates community involvement and education programs',
            'Strategic Planning' => 'Develops long-term strategies and investment plans',
            'Emergency Response' => 'Handles crisis management and disaster relief operations',
            'Environmental Protection' => 'Ensures environmental compliance and sustainability',
            'Technical Operations' => 'Oversees day-to-day technical operations and maintenance',
            'Research & Development' => 'Conducts research and develops innovative solutions',
        ];

        $name = $this->faker->randomElement(array_keys($departments));

        return [
            'name' => $name,
            'description' => $departments[$name],
        ];
    }
}
