<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\CompletionReport>
 */
class CompletionReportFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'description' => fake()->sentence(),
            'value' => fake()->randomFloat(2, 100, 10000),
            'delivery_date' => fake()->dateTimeBetween('-1 month', '+1 month'),
            'status' => \App\Models\CompletionReport::STATUS_APPROVED,
            'project_charter_deliverable_id' => \App\Models\ProjectCharterDeliverable::factory(),
            'created_by' => \App\Models\User::factory(),
        ];
    }
}
