<?php

namespace Database\Factories;

use App\Models\City;
use App\Models\State;
use Illuminate\Database\Eloquent\Factories\Factory;

class CityFactory extends Factory
{
    protected $model = City::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => [
                'ar' => $this->faker->city(),
                'en' => $this->faker->city(),
            ],
            'state_id' => State::factory(),
            'lat' => $this->faker->latitude(16, 32), // Saudi Arabia latitude range
            'lng' => $this->faker->longitude(34, 56), // Saudi Arabia longitude range
        ];
    }

    /**
     * City without coordinates
     */
    public function withoutCoordinates(): static
    {
        return $this->state(fn (array $attributes) => [
            'lat' => null,
            'lng' => null,
        ]);
    }

    /**
     * City with specific state
     */
    public function forState(State $state): static
    {
        return $this->state(fn (array $attributes) => [
            'state_id' => $state->id,
        ]);
    }
}
