<?php

namespace Database\Factories;

use App\Models\Association;
use Illuminate\Database\Eloquent\Factories\Factory;

class AssociationFactory extends Factory
{
    protected $model = Association::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->company().' Environmental Association',
            'license_number' => $this->faker->regexify('[A-Z]{3}-[0-9]{4}-[0-9]{3}'),
            'license_expiration_date' => $this->faker->dateTimeBetween('+6 months', '+3 years'),
            'representative_full_name' => $this->faker->name(),
            'representative_position' => $this->faker->randomElement([
                'Executive Director',
                'President',
                'Chairman',
                'General Manager',
                'Founder',
            ]),
            'phone_number' => $this->faker->regexify('\+966[0-9]{9}'),
            'secondary_phone_number' => $this->faker->regexify('\+966[0-9]{9}'),
            'email' => $this->faker->unique()->safeEmail(),
            'city' => $this->faker->city(),
            'postal_code' => $this->faker->postcode(),
            'neighborhood' => $this->faker->streetName(),
            'building_number' => $this->faker->buildingNumber(),
            'street' => $this->faker->streetAddress(),
            'branch_number' => $this->faker->numberBetween(1, 10),
            'lat' => $this->faker->latitude(15, 35), // Saudi Arabia bounds
            'lng' => $this->faker->longitude(30, 55), // Saudi Arabia bounds
            'iban' => 'SA'.$this->faker->numerify('####################'),
            'bank_name' => $this->faker->randomElement([
                'Saudi National Bank',
                'Al Rajhi Bank',
                'Riyad Bank',
                'SABB',
                'Banque Saudi Fransi',
            ]),
            'account_holder_name' => $this->faker->company(),
            'is_verified' => $this->faker->boolean(70),
            'is_locked' => $this->faker->boolean(10),
        ];
    }

    public function verified(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_verified' => true,
        ]);
    }

    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_verified' => false,
        ]);
    }

    public function locked(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_locked' => true,
        ]);
    }
}
