<?php

namespace Database\Factories;

use App\Models\AdminsTask;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\AdminsTask>
 */
class AdminsTaskFactory extends Factory
{
    protected $model = AdminsTask::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startDate = $this->faker->dateTimeBetween('-1 month', '+1 month');
        $endDate = $this->faker->dateTimeBetween($startDate, '+2 months');

        return [
            'name' => $this->faker->sentence(4),
            'description' => $this->faker->paragraph(),
            'start_date' => $startDate,
            'end_date' => $endDate,
            'status' => $this->faker->randomElement([
                AdminsTask::STATUS_PENDING,
                AdminsTask::STATUS_IN_PROGRESS,
                AdminsTask::STATUS_COMPLETED,
                AdminsTask::STATUS_CANCELLED,
                AdminsTask::STATUS_ON_HOLD,
            ]),
            'created_by' => User::factory(),
        ];
    }

    /**
     * Indicate that the task is pending.
     */
    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => AdminsTask::STATUS_PENDING,
        ]);
    }

    /**
     * Indicate that the task is in progress.
     */
    public function inProgress(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => AdminsTask::STATUS_IN_PROGRESS,
        ]);
    }

    /**
     * Indicate that the task is completed.
     */
    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => AdminsTask::STATUS_COMPLETED,
        ]);
    }

    /**
     * Indicate that the task is overdue.
     */
    public function overdue(): static
    {
        return $this->state(fn (array $attributes) => [
            'end_date' => $this->faker->dateTimeBetween('-1 month', '-1 day'),
            'status' => $this->faker->randomElement([
                AdminsTask::STATUS_PENDING,
                AdminsTask::STATUS_IN_PROGRESS,
            ]),
        ]);
    }
}
