<?php

namespace App\Services;

use Illuminate\Notifications\Notifiable;

class OtpRecipient
{
    use Notifiable;

    public function __construct(
        public string $identifier,
        public string $channel
    ) {}

    public function routeNotificationForMail()
    {
        return $this->channel === 'email' ? $this->identifier : null;
    }

    public function routeNotificationFor($driver)
    {
        if ($driver === 'mail') {
            return $this->channel === 'email' ? $this->identifier : null;
        }

        if ($driver === 'sms') {
            return $this->channel === 'sms' ? $this->identifier : null;
        }

        return null;
    }

    // For SMS notifications - provide phone number access
    public function __get($name)
    {
        if (($name === 'phone' || $name === 'phone_number') && $this->channel === 'sms') {
            return $this->identifier;
        }

        return null;
    }
}
