<?php

namespace App\Providers\Filament;

use App\Http\Middleware\EnsureUserHasAssociation;
use App\Livewire\OtpLogin;
use Archilex\AdvancedTables\Plugin\AdvancedTablesPlugin;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\Support\Facades\Vite;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Leandrocfe\FilamentApexCharts\FilamentApexChartsPlugin;

class AssociationAdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('association-admin')
            ->path('association-admin')
            ->login(OtpLogin::class)
            ->colors([
                'primary' => Color::Blue,
            ])
            ->brandLogo(Vite::asset('resources/images/sekaya-association-admin-brand-logo.svg'))
            ->brandLogoHeight('3rem')
            ->discoverResources(in: app_path('Filament/AssociationAdmin/Resources'), for: 'App\\Filament\\AssociationAdmin\\Resources')
            ->discoverPages(in: app_path('Filament/AssociationAdmin/Pages'), for: 'App\\Filament\\AssociationAdmin\\Pages')
            ->discoverClusters(in: app_path('Filament/AssociationAdmin/Clusters'), for: 'App\\Filament\\AssociationAdmin\\Clusters')
            ->pages([])
            ->resources([])
            ->discoverWidgets(in: app_path('Filament/AssociationAdmin/Widgets'), for: 'App\\Filament\\AssociationAdmin\\Widgets')
            ->widgets([])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->viteTheme('resources/css/filament/association-admin/theme.css')
            ->authMiddleware([
                Authenticate::class,
                EnsureUserHasAssociation::class,
            ])
            ->plugins([
                \BezhanSalleh\FilamentShield\FilamentShieldPlugin::make(),
                AdvancedTablesPlugin::make()
                    ->userViewsEnabled(false)
                    ->viewManagerEnabled(false)
                    ->viewManagerBadge(false)
                    ->resourceEnabled(false)
                    ->resourceNavigationBadge(false)
                    ->favoritesBarEnabled(false)
                    ->favoritesBarDefaultView(false),
                FilamentApexChartsPlugin::make(),
            ])
            ->darkMode(false)
            ->sidebarCollapsibleOnDesktop()
            ->globalSearch(false)
            ->colors([
                'danger' => Color::Rose,
                'gray' => Color::Zinc,
                'info' => Color::Blue,
                'primary' => Color::Blue,
                'success' => Color::Emerald,
                'warning' => Color::Yellow,
            ])
            ->font('Noto Sans Arabic');
    }
}
