<?php

namespace App\Providers\Filament;

use App\Livewire\AdminsOtpLogin;
use Archilex\AdvancedTables\Plugin\AdvancedTablesPlugin;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationGroup;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Heloufir\FilamentKanban\FilamentKanbanPlugin;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Vite;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Leandrocfe\FilamentApexCharts\FilamentApexChartsPlugin;
use Monzer\FilamentWorkflows\WorkflowsPlugin;
use Rupadana\ApiService\ApiServicePlugin;
use Whizzy\StackedTheme;

class AdminPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->default()
            ->id('admin')
            ->path('admin')
            ->login(AdminsOtpLogin::class)
            ->brandLogo(Vite::asset('resources/images/sekaya-association-admin-brand-logo.svg'))
            ->brandLogoHeight('3rem')

            ->discoverResources(in: app_path('Filament/Resources'), for: 'App\\Filament\\Resources')
            ->discoverPages(in: app_path('Filament/Pages'), for: 'App\\Filament\\Pages')
            ->discoverClusters(in: app_path('Filament/Clusters'), for: 'App\\Filament\\Clusters')
            ->pages([
                // Pages\Dashboard::class,
                \App\Filament\Pages\DefaultDashboard::class,
                \App\Filament\Pages\ProjectsDashboard::class,
                \App\Filament\Pages\OrdersDashboard::class,
                \App\Filament\Pages\FinancialPortfoliosDashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Widgets'), for: 'App\\Filament\\Widgets')
            ->widgets([])
            ->databaseNotifications()
            ->databaseNotificationsPolling('5s')
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->viteTheme('resources/css/filament/admin/theme.css')
            ->authMiddleware([
                Authenticate::class,
            ])
            ->plugins([
                \BezhanSalleh\FilamentShield\FilamentShieldPlugin::make()
                    ->gridColumns([
                        'default' => 1,
                        'sm' => 2,
                        'lg' => 3,
                    ])
                    ->sectionColumnSpan(1)
                    ->checkboxListColumns([
                        'default' => 1,
                        'sm' => 2,
                        'lg' => 3,
                    ])
                    ->resourceCheckboxListColumns([
                        'default' => 1,
                        'sm' => 2,
                    ]),
                AdvancedTablesPlugin::make()
                    ->userViewsEnabled(false)
                    ->viewManagerEnabled(false)
                    ->viewManagerBadge(false)
                    ->resourceEnabled(false)
                    ->resourceNavigationBadge(false)
                    ->favoritesBarEnabled(false)
                    ->favoritesBarDefaultView(false),
                WorkflowsPlugin::make()
                    // allow access if user has super_admin role
                    ->authorize(function () {
                        return Auth::user()->hasRole('super_admin');
                    })
                    ->actions([
                        \App\Filament\Workflows\Actions\SendEmailForCustomEvents::class,
                        \App\Filament\Workflows\Actions\SendEmailToRolesForCustomEvents::class,
                        \App\Filament\Workflows\Actions\SendEmailToAddressesForCustomEvents::class,
                    ])
                    ->navigationGroup(__('common.navigation.group.settings')),
                FilamentApexChartsPlugin::make(),
                new FilamentKanbanPlugin,
                ApiServicePlugin::make(),
                // StackedTheme::make()
            ])
            ->darkMode(false)
            ->sidebarCollapsibleOnDesktop()
            ->globalSearch(false)
            ->colors([
                'danger' => Color::Rose,
                'gray' => Color::Zinc,
                'info' => Color::Blue,
                'primary' => Color::Blue,
                'success' => Color::Emerald,
                'warning' => Color::Yellow,
            ])
            ->font('Noto Sans Arabic')
            ->navigationGroups([
                NavigationGroup::make(__('common.navigation.group.donors'))
                    ->icon('heroicon-o-banknotes')
                    ->collapsed(),
                NavigationGroup::make(__('common.navigation.group.association_management'))
                    ->icon('heroicon-o-building-library')
                    ->collapsed(),
                NavigationGroup::make(__('common.navigation.group.license_management'))
                    ->icon('heroicon-o-building-library')
                    ->collapsed(),
                NavigationGroup::make(__('common.navigation.group.project_management'))
                    ->icon('heroicon-o-squares-2x2')
                    ->collapsed(),
                NavigationGroup::make(__('common.navigation.group.user_management'))
                    ->icon('heroicon-o-users')
                    ->collapsed(),
                NavigationGroup::make(__('common.navigation.group.settings'))
                    ->icon('heroicon-o-cog-6-tooth')
                    ->collapsed(),
            ]);
    }
}
