<?php

namespace App\Providers;

use App\Models\ProjectCharterDeliverable;
use App\Observers\ProjectCharterDeliverableObserver;
use BezhanSalleh\FilamentLanguageSwitch\Enums\Placement;
use BezhanSalleh\FilamentLanguageSwitch\LanguageSwitch;
use Filament\Facades\Filament;
use Filament\Infolists\Infolist;
use Filament\Tables\Table;
use Filament\View\PanelsRenderHook;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::policy(\Spatie\Permission\Models\Role::class, \App\Policies\RolePolicy::class);
        // Gate::policy(\Spatie\Permission\Models\Permission::class, \App\Policies\PermissionPolicy::class);

        // Register model observers
        ProjectCharterDeliverable::observe(ProjectCharterDeliverableObserver::class);

        LanguageSwitch::configureUsing(function (LanguageSwitch $switch) {
            $switch
                ->locales(['ar', 'en'])
                ->outsidePanelRoutes(
                    [
                        'register.association',
                        'association.pending-approval',
                        'filament.association-admin.auth.login',
                    ]
                )
                ->outsidePanelPlacement(Placement::TopRight)
                ->visible(outsidePanels: true);
        });

        Table::$defaultNumberLocale = 'en';
        Infolist::$defaultNumberLocale = 'en';

        Table::$defaultDateDisplayFormat = 'Y/m/d';
        Infolist::$defaultDateDisplayFormat = 'Y/m/d';

        // Register Filament render hook for topbar greeting
        // This injects a greeting with the currently logged-in user's name
        // in the center of the Filament topbar using the TOPBAR_START hook
        Filament::registerRenderHook(
            PanelsRenderHook::TOPBAR_START,
            fn (): string => view('filament.topbar-greeting')->render()
        );
    }
}
