<?php

namespace App\Observers;

use App\Models\ProjectCharterDeliverable;
use App\Models\ProjectCharterTask;

class ProjectCharterDeliverableObserver
{
    /**
     * Handle the ProjectCharterDeliverable "created" event.
     */
    public function created(ProjectCharterDeliverable $deliverable): void
    {
        $this->createDefaultTask($deliverable);
    }

    /**
     * Create a default task for the deliverable
     */
    private function createDefaultTask(ProjectCharterDeliverable $deliverable): void
    {
        // Get the project charter to access start_date
        $projectCharter = $deliverable->projectCharter;

        ProjectCharterTask::create([
            'name' => 'مهمة لتقرير: '.$deliverable->name,
            'description' => null,
            'start_date' => $projectCharter?->start_date,
            'end_date' => $deliverable->expected_delivery_date,
            'progress_percentage' => 0,
            'estimated_cost' => 0,
            'actual_cost' => 0,
            'project_charter_deliverable_id' => $deliverable->id,
        ]);
    }
}
