<?php

namespace App\Notifications;

use App\Models\Association;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AssociationRegisteredNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     */
    public function __construct(public Association $association)
    {
        //
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Your Association Registration Was Received')
            ->greeting("Hello {$notifiable->representative_name},")
            ->line('Thank you for registering your association with us.')
            ->line("We've received your application and will review it shortly.")
            ->line("License Number: {$notifiable->license_number}")
            ->line('Status: Pending Review')
            ->line('You will be notified once your application is reviewed.')
            ->salutation('Regards, Sekaya Team');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
