<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class ServiceProvider extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $fillable = [
        'name',

        // Media collection attributes for SpatieMediaLibraryFileUpload
        'contract',
        'commercial_registration',
        'iban_certificate',
    ];

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('contract')->singleFile();
        $this->addMediaCollection('commercial_registration')->singleFile();
        $this->addMediaCollection('iban_certificate')->singleFile();
    }

    /**
     * Get the project charters that belong to this service provider
     */
    public function projectCharters(): HasMany
    {
        return $this->hasMany(ProjectCharter::class);
    }

    // a temp url attribute for contract file
    public function getContractTemporaryUrl(): ?string
    {
        return $this->getFirstMedia('contract')?->getTemporaryUrl(Carbon::now()->addMinutes(5));
    }

    // a temp url attribute for commercial registration file
    public function getCommercialRegistrationTemporaryUrl(): ?string
    {
        return $this->getFirstMedia('commercial_registration')?->getTemporaryUrl(Carbon::now()->addMinutes(5));
    }

    // a temp url attribute for iban certificate file
    public function getIbanCertificateTemporaryUrl(): ?string
    {
        return $this->getFirstMedia('iban_certificate')?->getTemporaryUrl(Carbon::now()->addMinutes(5));
    }
}
