<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class SekayaValue extends Model
{
    use HasFactory;

    const TYPE_ORDER_IMPACT_REASONS = 'REQUEST_IMPACT_REASONS';

    const TYPE_PERFORMANCE_CARD_PRODUCT = 'PERFORMANCE_CARD_PRODUCT';

    protected $fillable = [
        'name',
        'type',
    ];

    public function orders(): BelongsToMany
    {
        return $this->belongsToMany(Order::class);
    }

    public function performanceCards(): BelongsToMany
    {
        return $this->belongsToMany(PerformanceCard::class, 'performance_card_sekaya_value');
    }
}
