<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;
use Monzer\FilamentWorkflows\Traits\TrackWorkflowModelEvents;

class RiskRegister extends Model
{
    use HasFactory, TrackWorkflowModelEvents;

    const IMPACT_LEVEL_LOW = 'low';

    const IMPACT_LEVEL_MEDIUM = 'medium';

    const IMPACT_LEVEL_HIGH = 'high';

    const LIKELIHOOD_LEVEL_LOW = 'low';

    const LIKELIHOOD_LEVEL_MEDIUM = 'medium';

    const LIKELIHOOD_LEVEL_HIGH = 'high';

    protected $fillable = [
        'charter_id',
        'incident_likelihood',
        'impact_level',
        'impact_on_cost',
        'impact_on_time',
        'mitigation_plan',
        'contingency_plan',
        'financial_contingency',
        'technical_contingency',
        'created_by',
    ];

    /**
     * Get the project charter that owns the risk register.
     */
    public function charter(): BelongsTo
    {
        return $this->belongsTo(ProjectCharter::class, 'charter_id');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Boot the model
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = Auth::id();
            }
        });
    }
}
