<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class ResidentialGathering extends Model
{
    protected $fillable = [
        'name',
        'center_id',
        'type',
        'families_count',
        'population',
    ];

    protected $casts = [
        'families_count' => 'integer',
        'population' => 'integer',
    ];

    public function center(): BelongsTo
    {
        return $this->belongsTo(Center::class);
    }

    public function orders(): BelongsToMany
    {
        return $this->belongsToMany(Order::class);
    }

    public function associations(): BelongsToMany
    {
        return $this->belongsToMany(Association::class);
    }

    public function wellLicenses(): BelongsToMany
    {
        return $this->belongsToMany(WellLicense::class);
    }

    public function stationLicenses(): BelongsToMany
    {
        return $this->belongsToMany(StationLicense::class);
    }
}
