<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;

class ProjectGovernance extends Model
{
    use HasFactory;

    protected $fillable = [
        'charter_id',
        'name',
        'description',
        'created_by',
    ];

    /**
     * Get the project charter that owns the project governance.
     */
    public function charter(): BelongsTo
    {
        return $this->belongsTo(ProjectCharter::class, 'charter_id');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Boot the model
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = Auth::id();
            }
        });
    }
}
