<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Auth;

class PerformanceCardResult extends Model
{
    use HasFactory;

    protected $fillable = [
        'performance_card_id',
        'result',
        'created_by',
    ];

    public function performanceCard(): BelongsTo
    {
        return $this->belongsTo(PerformanceCard::class);
    }

    public function projectCharters(): BelongsToMany
    {
        return $this->belongsToMany(ProjectCharter::class, 'project_charter_performance_card_result');
    }

    public function initiativeResults(): BelongsToMany
    {
        return $this->belongsToMany(InitiativeResult::class, 'initiative_result_pcr');
    }

    public function creator(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Boot the model
     */
    protected static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = Auth::id();
            }
        });
    }
}
