<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

class Otp extends Model
{
    protected $fillable = [
        'identifier',
        'code',
        'channel',
        'used',
        'expires_at',
    ];

    protected $casts = [
        'used' => 'boolean',
        'expires_at' => 'datetime',
    ];

    public function scopeValid(Builder $query, string $identifier, string $code): Builder
    {
        return $query->where('identifier', $identifier)
            ->where('code', $code)
            ->where('used', false)
            ->where('expires_at', '>', now());
    }
}
