<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class City extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'state_id',
        'lat',
        'lng',
    ];

    public function state(): BelongsTo
    {
        return $this->belongsTo(State::class);
    }

    public function centers(): HasMany
    {
        return $this->hasMany(Center::class);
    }

    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }

    public function associations(): BelongsToMany
    {
        return $this->belongsToMany(Association::class);
    }

    /**
     * Scope a query to order by name.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @param  string  $direction
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeOrderByName($query, $direction = 'asc')
    {
        return $query->orderBy('name', $direction);
    }
}
