<?php

namespace App\Models;

use App\Enums\AssociationType;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\MediaLibrary\HasMedia;
use Spatie\MediaLibrary\InteractsWithMedia;

class AssociationRegistration extends Model implements HasMedia
{
    use HasFactory, InteractsWithMedia;

    protected $fillable = [
        'name',
        'type',
        'license_number',
        'license_expiration_date',
        'representative_full_name',
        'representative_position',
        'phone_number',
        'email',
        'status',
    ];

    protected $casts = [
        'type' => AssociationType::class,
        'license_expiration_date' => 'date',
    ];

    public const STATUS_PENDING_VERIFICATION = 'pending_verification';

    public const STATUS_COMPLETED = 'completed';

    public const STATUS_EXPIRED = 'expired';

    public function registerMediaCollections(): void
    {
        $this->addMediaCollection('logo')->singleFile();
        $this->addMediaCollection('authorization_letter')->singleFile();
        $this->addMediaCollection('license_certificate')->singleFile();
    }

    // OTP logic now delegated entirely to OtpService & otps table.
}
