<?php

namespace App\Models;

use Heloufir\FilamentKanban\Interfaces\KanbanStatusModel;
use Heloufir\FilamentKanban\ValueObjects\KanbanStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AdminsTaskStatus extends Model implements KanbanStatusModel
{
    use HasFactory;

    protected $fillable = [
        'key',
        'title',
        'icon',
        'color',
        'order_column',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'order_column' => 'integer',
    ];

    protected $attributes = [
        'is_active' => true,
    ];

    /**
     * Get the tasks that have this status
     */
    public function adminsTasks(): HasMany
    {
        return $this->hasMany(AdminsTask::class, 'status_id');
    }

    /**
     * Get only active statuses ordered by order_column
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true)->orderBy('order_column');
    }

    /**
     * Get status by key
     */
    public function scopeByKey($query, string $key)
    {
        return $query->where('key', $key);
    }

    /**
     * Get default status (first active status by order)
     */
    public static function getDefault(): ?self
    {
        return static::active()->first();
    }

    public function toKanbanStatus(): KanbanStatus
    {
        return KanbanStatus::make()
            ->id($this->id)
            ->title($this->title)
            ->icon($this->icon)
            ->color($this->color);
    }
}
