<?php

namespace App\Filament\Widgets;

use App\Models\WellLicense;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Cheesegrits\FilamentGoogleMaps\Widgets\MapWidget;

class WellLicensesMap extends MapWidget
{
    use HasWidgetShield;

    protected static ?string $heading = 'خريطة تراخيص الآبار';

    protected static ?int $sort = 1;

    protected static ?string $pollingInterval = null;

    protected static ?bool $clustering = true;

    protected static ?bool $fitToBounds = true;

    protected static ?int $zoom = 8;

    protected array $mapConfig = [
        'draggable' => false,
        'center' => [
            'lat' => 24.7136, // Default latitude (Riyadh)
            'lng' => 46.6753, // Default longitude (Riyadh)
        ],
        'zoom' => 8,
        'fit' => true,
        'gmaps' => '',
        'clustering' => true,
        'mapConfig' => [],
    ];

    protected int|string|array $columnSpan = 'full';

    protected function getData(): array
    {
        $locations = WellLicense::whereNotNull('lat')
            ->whereNotNull('lng')
            ->get();

        $data = [];

        foreach ($locations as $location) {
            $data[] = [
                'location' => [
                    'lat' => $location->lat ? round(floatval($location->lat), static::$precision) : 0,
                    'lng' => $location->lng ? round(floatval($location->lng), static::$precision) : 0,
                ],

                'label' => '#'.$location->id.': '.$location->well_name.' - '.$location->association->name,

                'id' => $location->getKey(),
            ];
        }

        return $data;
    }
}
