<?php

namespace App\Filament\Widgets;

use App\Models\RiskRegister;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Leandrocfe\FilamentApexCharts\Widgets\ApexChartWidget;

class ProjectRiskMatrixChart extends ApexChartWidget
{
    use HasWidgetShield;

    protected static ?string $chartId = 'projectRiskMatrixChart';

    protected static ?string $heading = 'null';

    protected static bool $isLazy = false;

    protected static ?string $pollingInterval = null;

    protected RiskRegister $riskRegister;

    public function __construct()
    {
        $this->riskRegister = new RiskRegister;
    }

    protected function getHeading(): string
    {
        return __('pages.projects_dashboard').' - '.__('widgets.project_risk_matrix');
    }

    protected function getOptions(): array
    {
        $likelihoods = [
            $this->riskRegister::LIKELIHOOD_LEVEL_LOW,
            $this->riskRegister::LIKELIHOOD_LEVEL_MEDIUM,
            $this->riskRegister::LIKELIHOOD_LEVEL_HIGH,
        ];

        $impacts = [
            $this->riskRegister::IMPACT_LEVEL_LOW,
            $this->riskRegister::IMPACT_LEVEL_MEDIUM,
            $this->riskRegister::IMPACT_LEVEL_HIGH,
        ];

        $matrix = [];
        foreach ($likelihoods as $likelihood) {
            $row = [];
            foreach ($impacts as $impact) {
                $row[] = $this->riskRegister::query()
                    ->where('incident_likelihood', $likelihood)
                    ->where('impact_level', $impact)
                    ->count();
            }
            $matrix[] = $row;
        }

        return [
            'chart' => [
                'type' => 'heatmap',
                'fontFamily' => 'inherit',
                'height' => 260,
                'toolbar' => ['show' => true],
            ],
            'plotOptions' => [
                'heatmap' => [
                    'shadeIntensity' => 0.5,
                    'colorScale' => [
                        'ranges' => [
                            [
                                'from' => 0, 'to' => 0,
                                'color' => '#f4f4f4',
                                'name' => __('widgets.no_risk'),
                            ],
                            [
                                'from' => 1, 'to' => 2,
                                'color' => '#01bf7f',
                                'name' => __('widgets.low_risk'),
                            ],
                            [
                                'from' => 3, 'to' => 5,
                                'color' => '#febd00',
                                'name' => __('widgets.medium_risk'),
                            ],
                            [
                                'from' => 6, 'to' => 99999,
                                'color' => '#fd4954',
                                'name' => __('widgets.high_risk'),
                            ],
                        ],
                    ],
                ],
            ],
            'dataLabels' => ['enabled' => true],
            'xaxis' => [
                'categories' => [
                    __('risk_register.impact_low'),
                    __('risk_register.impact_medium'),
                    __('risk_register.impact_high'),
                ],
                'title' => [
                    'offsetY' => -20,
                    'text' => __('risk_register.impact_level'),
                    'style' => [
                        'fontSize' => '10px',
                        'fontWeight' => 'bold',
                    ],
                ],
            ],
            'yaxis' => [
                'categories' => [
                    __('risk_register.likelihood_low'),
                    __('risk_register.likelihood_medium'),
                    __('risk_register.likelihood_high'),
                ],
                'title' => [
                    'text' => __('risk_register.incident_likelihood'),
                    'style' => [
                        'fontSize' => '10px',
                        'fontWeight' => 'bold',
                    ],
                ],
            ],
            'series' => [
                [
                    'name' => __('risk_register.likelihood_low'),
                    'data' => $matrix[0],
                ],
                [
                    'name' => __('risk_register.likelihood_medium'),
                    'data' => $matrix[1],
                ],
                [
                    'name' => __('risk_register.likelihood_high'),
                    'data' => $matrix[2],
                ],
            ],
            'states' => [
                'hover' => [
                    'filter' => [
                        'type' => 'none',
                    ],
                ],
                'active' => [
                    'filter' => [
                        'type' => 'none',
                    ],
                ],
            ],

        ];
    }
}
