<?php

namespace App\Filament\Widgets;

use App\Models\Order;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Cheesegrits\FilamentGoogleMaps\Widgets\MapWidget;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Illuminate\Support\Facades\Log;

class OrdersMap extends MapWidget
{
    use HasWidgetShield, InteractsWithPageFilters;

    protected static ?string $heading = 'خريطة الطلبات';

    protected static ?int $sort = 4;

    public function getHeading(): string
    {
        return __('pages.orders_dashboard').' - '.'خريطة الطلبات';
    }

    protected static ?string $pollingInterval = null;

    protected static ?bool $clustering = true;

    protected static ?bool $fitToBounds = true;

    protected static ?int $zoom = 12;

    protected array $mapConfig = [
        'draggable' => false,
        'center' => [
            'lat' => 24.7136, // Default latitude
            'lng' => 46.6753, // Default longitude
        ],
        'zoom' => 8,
        'fit' => true,
        'gmaps' => '',
        'clustering' => true,
        'mapConfig' => [],
    ];

    protected int|string|array $columnSpan = 'full';

    protected function getData(): array
    {
        // Get filter value
        $selectedYear = $this->filters['year'] ?? null;

        /**
         * You can use whatever query you want here, as long as it produces a set of records with your
         * lat and lng fields in them.
         */
        $query = Order::where('status', Order::STATUS_ACCEPTED)->filterByTypePermissions();
        if ($selectedYear) {
            $query->whereYear('created_at', $selectedYear);
        }

        $locations = $query->get();

        $data = [];

        foreach ($locations as $location) {

            Log::debug('Processing location '.$location);
            Log::debug('Processing location '.$location->getKey().' with lat: '.$location->lat.' and lng: '.$location->lng);

            /**
             * Each element in the returned data must be an array
             * containing a 'location' array of 'lat' and 'lng',
             * and a 'label' string (optional but recommended by Google
             * for accessibility.
             *
             * You should also include an 'id' attribute for internal use by this plugin
             */
            $data[] = [
                'location' => [
                    'lat' => $location->lat ? round(floatval($location->lat), static::$precision) : 0,
                    'lng' => $location->lng ? round(floatval($location->lng), static::$precision) : 0,
                ],

                'label' => '#'.$location->id.': '.$location->association->name,

                'id' => $location->getKey(),

            /**
             * Optionally you can provide custom icons for the map markers,
             * either as scalable SVG's, or PNG, which doesn't support scaling.
             * If you don't provide icons, the map will use the standard Google marker pin.
             */
                // 'icon' => [
                //     'url' => url('images/dealership.svg'),
                //     'type' => 'svg',
                //     'scale' => [35, 35],
                // ],
            ];
        }

        return $data;
    }
}
