<?php

namespace App\Filament\Widgets;

use App\Models\DonorFinancialPortfolio;
use App\Models\Order;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Support\HtmlString;

class FinancialPortfoliosStatusTable extends BaseWidget
{
    use HasWidgetShield, InteractsWithPageFilters;

    protected static ?string $heading = null;

    protected static ?int $sort = 4;

    protected int|string|array $columnSpan = 'full';

    public function getHeading(): string
    {
        return __('pages.financial_portfolios_dashboard').' - '.__('widgets.financial_portfolios_status');
    }

    public function getTableHeading(): string
    {
        return __('pages.financial_portfolios_dashboard').' - '.__('widgets.financial_portfolios_status');
    }

    public function table(Table $table): Table
    {
        return $table
            ->query(DonorFinancialPortfolio::query())
            ->columns([
                // اسم المانح
                Tables\Columns\TextColumn::make('name')
                    ->label('اسم المانح')
                    ->searchable()
                    ->sortable()
                    ->wrap(),

                // قيمة المحفظة
                Tables\Columns\TextColumn::make('balance')
                    ->label('قيمة المحفظة')
                    ->numeric(2)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->sortable()
                    ->color('primary'),

                // المنصرف (إجمالي المبالغ المخصصة)
                Tables\Columns\TextColumn::make('spent_amount')
                    ->label('المنصرف')
                    ->getStateUsing(fn (DonorFinancialPortfolio $record) => $record->total_allocated)
                    ->numeric(2)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->sortable()
                    ->color('success'),

                // المتبقي
                Tables\Columns\TextColumn::make('remaining_balance')
                    ->label('المتبقي')
                    ->numeric(2)
                    ->prefix(new HtmlString('<span class="icon-saudi_riyal"></span>'))
                    ->sortable()
                    ->color(fn ($state) => $state < 0 ? 'danger' : ($state == 0 ? 'warning' : 'success')),

                // الجمعيات المدعومة
                Tables\Columns\TextColumn::make('supported_associations')
                    ->label('الجمعيات المدعومة')
                    ->getStateUsing(fn (DonorFinancialPortfolio $record): int => $record->orders()
                        ->where('orders.status', '!=', Order::STATUS_REJECTED)
                        ->distinct('association_id')
                        ->count('association_id'))
                    ->badge()
                    ->alignCenter()
                    ->color('info'),
            ])
            ->filters([])
            ->defaultSort('created_at', 'desc')
            ->striped()
            ->paginated([10, 25, 50, 100])
            ->defaultPaginationPageOption(25);
    }
}
