<?php

namespace App\Filament\Widgets;

use App\Models\Association;
use App\Models\DonorFinancialPortfolio;
use App\Models\Order;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;

class FinancialPortfoliosStatsOverview extends BaseWidget
{
    use HasWidgetShield, InteractsWithPageFilters;

    protected static ?int $sort = 1;

    public function getHeading(): string
    {
        return __('pages.financial_portfolios_dashboard').' - '.__('widgets.total_financial_portfolios');
    }

    protected function getStats(): array
    {
        // Get total count of portfolios
        $totalPortfolios = DonorFinancialPortfolio::count();

        // Calculate total portfolio value
        $totalValue = DonorFinancialPortfolio::sum('balance');

        $totalAllocated = DonorFinancialPortfolio::all()->sum('total_allocated');

        // Calculate total operating value across all portfolios
        // $totalOperatingValue = DonorFinancialPortfolio::all()->sum('total_operating_value');

        // Calculate remaining balance
        $remainingBalance = $totalValue - $totalAllocated;

        $supportedAssociations = Association::query()
            ->whereHas('orders.donorFinancialPortfolios', function ($query) {
                $query->where('orders.status', '!=', Order::STATUS_REJECTED);
            })
            ->distinct()
            ->count();

        return [
            Stat::make(__('widgets.total_financial_portfolios'), $totalPortfolios)
                ->description(__('widgets.total_financial_portfolios_description'))
                ->descriptionIcon('heroicon-o-banknotes')
                ->color('primary'),

            Stat::make(__('widgets.total_portfolio_value'), number_format($totalValue, 0, '.', ','))
                ->description(__('widgets.total_portfolio_value_description'))
                ->descriptionIcon('heroicon-o-currency-dollar')
                ->color('success'),

            Stat::make(__('widgets.total_allocated_amount'), number_format($totalAllocated, 0, '.', ','))
                ->description(__('widgets.total_allocated_amount_description'))
                ->descriptionIcon('heroicon-o-arrow-trending-up')
                ->color('info'),

            // Stat::make(__('widgets.total_operating_value'), number_format($totalOperatingValue, 0, '.', ','))
            //     ->description(__('widgets.total_operating_value_description'))
            //     ->descriptionIcon('heroicon-o-cog-6-tooth')
            //     ->color('warning'),

            Stat::make(__('widgets.remaining_portfolio_balance'), number_format($remainingBalance, 0, '.', ','))
                ->description(__('widgets.remaining_portfolio_balance_description'))
                ->descriptionIcon('heroicon-o-wallet')
                ->color($remainingBalance > 0 ? 'success' : 'danger'),

            Stat::make(__('widgets.supported_associations'), $supportedAssociations)
                ->description(__('widgets.supported_associations_description'))
                ->descriptionIcon('heroicon-o-building-office-2')
                ->color('warning'),
        ];
    }
}
