<?php

namespace App\Filament\Widgets;

use App\Models\DonorFinancialPortfolio;
use App\Models\Order;
use BezhanSalleh\FilamentShield\Traits\HasWidgetShield;
use Filament\Widgets\Concerns\InteractsWithPageFilters;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\HtmlString;

class DonorPortfolioStatsOverview extends BaseWidget
{
    use HasWidgetShield, InteractsWithPageFilters;

    protected static ?int $sort = 1;

    public function getHeading(): string
    {
        return __('pages.financial_portfolios_dashboard').' - '.__('widgets.supported_projects_count');
    }

    protected function getStats(): array
    {
        // Get donor financial portfolios accessible to current user
        // $portfolios = DonorFinancialPortfolio::all();

        // Calculate total portfolio value for accessible portfolios
        // $totalPortfolioValue = $portfolios->sum('balance');

        // Count total supported projects (orders linked to accessible portfolios)
        $supportedProjectsCount = Order::whereHas('donorFinancialPortfolios', function ($query) {
            $query->whereIn('donor_financial_portfolio_id', DonorFinancialPortfolio::pluck('id'));
        })->count();

        // Calculate total beneficiary families from accepted orders linked to accessible portfolios
        $totalBeneficiaryFamilies = Order::where('status', Order::STATUS_ACCEPTED)
            ->whereHas('donorFinancialPortfolios', function ($query) {
                $query->whereIn('donor_financial_portfolio_id', DonorFinancialPortfolio::pluck('id'));
            })
            ->sum('number_of_families');

        return [
            // Stat::make(__('widgets.total_portfolio_value'), new HtmlString('<span class="icon-saudi_riyal"></span>' . number_format($totalPortfolioValue, 2)))
            //     ->description(__('widgets.total_portfolio_value_description'))
            //     ->descriptionIcon('heroicon-m-banknotes')
            //     ->color('success')
            //     ->extraAttributes([
            //         'class' => 'cursor-pointer',
            //     ]),

            Stat::make(__('widgets.supported_projects_count'), number_format($supportedProjectsCount))
                ->description(__('widgets.supported_projects_description'))
                ->descriptionIcon('heroicon-m-clipboard-document-list')
                ->color('primary')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                ]),

            Stat::make(__('widgets.beneficiary_families_count'), number_format($totalBeneficiaryFamilies))
                ->description(__('widgets.beneficiary_families_description'))
                ->descriptionIcon('heroicon-m-home')
                ->color('info')
                ->extraAttributes([
                    'class' => 'cursor-pointer',
                ]),
        ];
    }

    public function getColumns(): int
    {
        return 2;
    }
}
