<?php

namespace App\Filament\Resources\WellLicenseResource\Pages;

use App\Filament\Resources\WellLicenseResource;
use Filament\Resources\Pages\CreateRecord;

class CreateWellLicense extends CreateRecord
{
    protected static string $resource = WellLicenseResource::class;

    protected static string $view = 'filament.resources.well-license-resource.pages.create-well-license';

    public bool $termsAccepted = false;

    public bool $showForm = false;

    public function getTitle(): string
    {
        return __('well_license.create_well_license');
    }

    public function acceptTermsAndProceed(): void
    {
        if ($this->termsAccepted) {
            $this->showForm = true;
            $this->dispatch('close-modal', id: 'license-terms-modal');
        }
    }
}
