<?php

namespace App\Filament\Resources\UserResource\RelationManagers;

use App\Models\DonorFinancialPortfolio;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;

class DonorFinancialPortfoliosRelationManager extends RelationManager
{
    protected static string $relationship = 'donorFinancialPortfolios';

    public static function getTitle(\Illuminate\Database\Eloquent\Model $ownerRecord, string $pageClass): string
    {
        return __('donor_financial_portfolio.donor_financial_portfolios');
    }

    public static function getModelLabel(): string
    {
        return __('donor_financial_portfolio.donor_financial_portfolio');
    }

    public static function getPluralModelLabel(): string
    {
        return __('donor_financial_portfolio.donor_financial_portfolios');
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label(__('common.name'))
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('balance')
                    ->label(__('common.balance'))
                    ->numeric()
                    ->prefix('SAR')
                    ->disabled(),
                Forms\Components\TextInput::make('operating_percentage')
                    ->label(__('Operating Percentage'))
                    ->numeric()
                    ->suffix('%')
                    ->disabled(),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('common.name'))
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('balance')
                    ->label(__('common.balance'))
                    ->money('SAR')
                    ->sortable(),
                Tables\Columns\TextColumn::make('operating_percentage')
                    ->label(__('Operating Percentage'))
                    ->suffix('%')
                    ->sortable(),
                Tables\Columns\TextColumn::make('remaining_balance')
                    ->label(__('Remaining Balance'))
                    ->money('SAR')
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('common.created_at'))
                    ->date()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\AttachAction::make()
                    ->recordSelectSearchColumns(['name'])
                    ->recordSelectOptionsQuery(fn () => DonorFinancialPortfolio::withoutAccessScope())
                    ->multiple(),
            ])
            ->actions([
                Tables\Actions\DetachAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DetachBulkAction::make(),
                ]),
            ]);
    }

    public function isReadOnly(): bool
    {
        return false;
    }
}
