<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Actions;
use Filament\Infolists;
use Filament\Infolists\Infolist;
use Filament\Resources\Pages\ViewRecord;
use Ysfkaya\FilamentPhoneInput\Infolists\PhoneEntry;
use Ysfkaya\FilamentPhoneInput\PhoneInputNumberType;

class ViewUser extends ViewRecord
{
    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\EditAction::make(),
            Actions\DeleteAction::make(),
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Infolists\Components\Section::make(__('common.user_information'))
                    ->schema([
                        Infolists\Components\TextEntry::make('name')
                            ->label(__('common.name')),

                        Infolists\Components\TextEntry::make('job_title')
                            ->label(__('common.job_title'))
                            ->placeholder('—'),

                        Infolists\Components\TextEntry::make('email')
                            ->label(__('common.email'))
                            ->copyable()
                            ->icon('heroicon-o-envelope'),

                        PhoneEntry::make('phone_number')
                            ->label(__('common.phone_number'))
                            ->displayFormat(PhoneInputNumberType::NATIONAL),

                        Infolists\Components\TextEntry::make('association.name')
                            ->label(__('common.association'))
                            ->placeholder(__('common.no_association'))
                            ->url(fn ($record) => $record->association ? \App\Filament\Resources\AssociationResource::getUrl('view', ['record' => $record->association]) : null),
                    ])
                    ->columns(2),

                Infolists\Components\Section::make(__('common.roles_and_permissions'))
                    ->schema([
                        Infolists\Components\TextEntry::make('roles.name')
                            ->label(__('common.roles'))
                            ->badge()
                            ->separator(',')
                            ->placeholder(__('common.no_roles')),

                        Infolists\Components\TextEntry::make('departments.name')
                            ->label(__('common.departments'))
                            ->badge()
                            ->separator(',')
                            ->placeholder(__('common.no_departments')),
                    ])
                    ->columns(2),

                Infolists\Components\Section::make(__('common.system_information'))
                    ->schema([
                        Infolists\Components\TextEntry::make('created_at')
                            ->label(__('common.created_at'))
                            ->dateTime(),

                        Infolists\Components\TextEntry::make('updated_at')
                            ->label(__('common.updated_at'))
                            ->dateTime(),

                        // Infolists\Components\TextEntry::make('email_verified_at')
                        //     ->label(__('common.email_verified_at'))
                        //     ->dateTime()
                        //     ->placeholder(__('common.not_verified')),
                    ])
                    ->columns(3)
                    ->collapsible(),
            ]);
    }
}
