<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use App\Models\User;
use Archilex\AdvancedTables\AdvancedTables;
use Filament\Actions;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;

class ListUsers extends ListRecords
{
    use AdvancedTables;

    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            // // two tabs, one for all users whereNull('association_id') and one for users with an association
            // 'all' => Tab::make(__('common.all_users'))
            //     ->badge(UserResource::getEloquentQuery()->count()),
            'admins' => Tab::make(__('common.admins'))
                ->modifyQueryUsing(fn (Builder $query) => $query->whereNull('association_id'))
                ->badge(User::whereNull('association_id')->count()),
            'users_with_association' => Tab::make(__('common.users_with_association'))
                ->modifyQueryUsing(fn (Builder $query) => $query->whereNotNull('association_id'))
                ->badge(User::whereNotNull('association_id')->count()),
        ];
    }
}
