<?php

namespace App\Filament\Resources\StationLicenseResource\Pages;

use App\Filament\Resources\StationLicenseResource;
use Filament\Resources\Pages\CreateRecord;

class CreateStationLicense extends CreateRecord
{
    protected static string $resource = StationLicenseResource::class;

    protected static string $view = 'filament.resources.station-license-resource.pages.create-station-license';

    public bool $termsAccepted = false;

    public bool $showForm = false;

    public function getTitle(): string
    {
        return __('station_license.create_station_license');
    }

    public function acceptTermsAndProceed(): void
    {
        if ($this->termsAccepted) {
            $this->showForm = true;
            $this->dispatch('close-modal', id: 'license-terms-modal');
        }
    }

    protected function afterCreate(): void
    {
        // Copy ministry_license files from attached well licenses after relationships are synced
        $this->record->copyMinistryLicensesFromWells($this->record);
    }
}
