<?php

namespace App\Filament\Resources\ServiceProviderResource\Api\Handlers;

use App\Filament\Resources\ServiceProviderResource;
use App\Filament\Resources\ServiceProviderResource\Api\Requests\UpdateServiceProviderRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ServiceProviderResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update ServiceProvider
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateServiceProviderRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
