<?php

namespace App\Filament\Resources\ServiceProviderResource\Api\Handlers;

use App\Filament\Resources\ServiceProviderResource;
use App\Filament\Resources\ServiceProviderResource\Api\Transformers\ServiceProviderTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = ServiceProviderResource::class;

    /**
     * Show ServiceProvider
     *
     * @return ServiceProviderTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new ServiceProviderTransformer($query);
    }
}
