<?php

namespace App\Filament\Resources\ServiceProviderResource\Api\Handlers;

use App\Filament\Resources\ServiceProviderResource;
use App\Filament\Resources\ServiceProviderResource\Api\Requests\CreateServiceProviderRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = ServiceProviderResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create ServiceProvider
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateServiceProviderRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
