<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ServiceProviderResource\Pages;
use App\Models\ServiceProvider;
use Filament\Forms;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class ServiceProviderResource extends Resource
{
    protected static ?string $model = ServiceProvider::class;

    protected static ?string $navigationIcon = 'heroicon-o-truck';

    protected static ?int $navigationSort = 10;

    public static function getNavigationLabel(): string
    {
        return __('service_provider.service_providers');
    }

    public static function getModelLabel(): string
    {
        return __('service_provider.service_provider');
    }

    public static function getPluralModelLabel(): string
    {
        return __('service_provider.service_providers');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.settings');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make(__('service_provider.basic_information'))
                    ->description(__('service_provider.basic_information_description'))
                    ->schema([
                        Forms\Components\TextInput::make('name')
                            ->label(__('service_provider.name'))
                            ->required()
                            ->maxLength(255)
                            ->helperText(__('service_provider.name_helper')),
                    ])
                    ->columnSpanFull(),

                Forms\Components\Section::make(__('service_provider.documents'))
                    ->description(__('service_provider.documents_description'))
                    ->schema([
                        SpatieMediaLibraryFileUpload::make('contract')
                            ->label(__('service_provider.contract'))
                            ->collection('contract')
                            ->visibility('private')
                            ->acceptedFileTypes(['application/pdf', 'image/jpeg', 'image/png'])
                            ->maxSize(5120)
                            ->downloadable()
                            ->helperText(__('service_provider.contract_helper')),

                        SpatieMediaLibraryFileUpload::make('commercial_registration')
                            ->label(__('service_provider.commercial_registration'))
                            ->collection('commercial_registration')
                            ->visibility('private')
                            ->acceptedFileTypes(['application/pdf', 'image/jpeg', 'image/png'])
                            ->maxSize(5120)
                            ->downloadable()
                            ->helperText(__('service_provider.commercial_registration_helper')),

                        SpatieMediaLibraryFileUpload::make('iban_certificate')
                            ->label(__('service_provider.iban_certificate'))
                            ->collection('iban_certificate')
                            ->visibility('private')
                            ->acceptedFileTypes(['application/pdf', 'image/jpeg', 'image/png'])
                            ->maxSize(5120)
                            ->downloadable()
                            ->helperText(__('service_provider.iban_certificate_helper')),
                    ])
                    ->columns(1),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label(__('service_provider.name'))
                    ->sortable()
                    ->searchable(),

                Tables\Columns\IconColumn::make('has_contract')
                    ->label(__('service_provider.contract'))
                    ->boolean()
                    ->getStateUsing(fn ($record) => $record->hasMedia('contract')),

                Tables\Columns\IconColumn::make('has_commercial_registration')
                    ->label(__('service_provider.commercial_registration'))
                    ->boolean()
                    ->getStateUsing(fn ($record) => $record->hasMedia('commercial_registration')),

                Tables\Columns\IconColumn::make('has_iban_certificate')
                    ->label(__('service_provider.iban_certificate'))
                    ->boolean()
                    ->getStateUsing(fn ($record) => $record->hasMedia('iban_certificate')),

                Tables\Columns\TextColumn::make('created_at')
                    ->date()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('created_at', 'desc');
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListServiceProviders::route('/'),
            'create' => Pages\CreateServiceProvider::route('/create'),
            'edit' => Pages\EditServiceProvider::route('/{record}/edit'),
        ];
    }
}
