<?php

namespace App\Filament\Resources\SekayaValueResource\Pages;

use App\Filament\Resources\SekayaValueResource;
use App\Models\SekayaValue;
use Filament\Actions;
use Filament\Resources\Components\Tab;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Database\Eloquent\Builder;

class ListSekayaValues extends ListRecords
{
    protected static string $resource = SekayaValueResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\CreateAction::make(),
        ];
    }

    public function getTabs(): array
    {
        return [
            // 'all' => Tab::make(__('sekaya_value.all'))
            //     ->badge(SekayaValue::count()),

            'products' => Tab::make(__('sekaya_value.products'))
                ->modifyQueryUsing(fn (Builder $query) => $query->where('type', SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT))
                ->badge(SekayaValue::where('type', SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT)->count()),

            'development_impact' => Tab::make(__('sekaya_value.development_impact'))
                ->modifyQueryUsing(fn (Builder $query) => $query->where('type', SekayaValue::TYPE_ORDER_IMPACT_REASONS))
                ->badge(SekayaValue::where('type', SekayaValue::TYPE_ORDER_IMPACT_REASONS)->count()),

        ];
    }
}
