<?php

namespace App\Filament\Resources\SekayaValueResource\Api\Handlers;

use App\Filament\Resources\SekayaValueResource;
use App\Filament\Resources\SekayaValueResource\Api\Requests\UpdateSekayaValueRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = SekayaValueResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update SekayaValue
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateSekayaValueRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
