<?php

namespace App\Filament\Resources\SekayaValueResource\Api\Handlers;

use App\Filament\Resources\SekayaValueResource;
use App\Filament\Resources\SekayaValueResource\Api\Transformers\SekayaValueTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = SekayaValueResource::class;

    /**
     * Show SekayaValue
     *
     * @return SekayaValueTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new SekayaValueTransformer($query);
    }
}
