<?php

namespace App\Filament\Resources\SekayaValueResource\Api\Handlers;

use App\Filament\Resources\SekayaValueResource;
use App\Filament\Resources\SekayaValueResource\Api\Requests\CreateSekayaValueRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = SekayaValueResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create SekayaValue
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateSekayaValueRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
