<?php

namespace App\Filament\Resources;

use App\Filament\Resources\SekayaValueResource\Pages;
use App\Models\SekayaValue;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;

class SekayaValueResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = SekayaValue::class;

    protected static ?string $navigationIcon = 'heroicon-o-squares-2x2';

    protected static ?int $navigationSort = 8;

    public static function getNavigationLabel(): string
    {
        return __('sekaya_value.sekaya_values');
    }

    public static function getModelLabel(): string
    {
        return __('sekaya_value.sekaya_value');
    }

    public static function getPluralModelLabel(): string
    {
        return __('sekaya_value.sekaya_values');
    }

    public static function getNavigationGroup(): ?string
    {
        return __('common.navigation.group.settings');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Section::make(__('sekaya_value.sekaya_value_information'))
                    ->description(__('sekaya_value.sekaya_value_information_description'))
                    ->schema([
                        Forms\Components\TextInput::make('name')
                            ->label(__('sekaya_value.name'))
                            ->required()
                            ->maxLength(255)
                            ->placeholder('Enter the name...'),

                        Forms\Components\Select::make('type')
                            ->label(__('sekaya_value.type'))
                            ->required()
                            ->options([
                                SekayaValue::TYPE_ORDER_IMPACT_REASONS => __('sekaya_value.development_impact'),
                                SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT => __('sekaya_value.products'),
                            ])
                            ->native(false)
                            ->placeholder('Select a type...'),
                    ])
                    ->columns(2),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label(__('sekaya_value.id'))
                    ->sortable()
                    ->toggleable(),

                Tables\Columns\TextColumn::make('name')
                    ->label(__('sekaya_value.name'))
                    ->searchable()
                    ->sortable()
                    ->weight('medium'),

                Tables\Columns\BadgeColumn::make('type')
                    ->label(__('sekaya_value.type'))
                    ->formatStateUsing(function (string $state): string {
                        return match ($state) {
                            SekayaValue::TYPE_ORDER_IMPACT_REASONS => __('sekaya_value.development_impact'),
                            SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT => __('sekaya_value.products'),
                            default => $state,
                        };
                    })
                    ->colors([
                        'success' => SekayaValue::TYPE_ORDER_IMPACT_REASONS,
                        'primary' => SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT,
                    ])
                    ->sortable(),

                Tables\Columns\TextColumn::make('created_at')
                    ->label(__('sekaya_value.created_at'))
                    ->date()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),

                Tables\Columns\TextColumn::make('updated_at')
                    ->label(__('sekaya_value.updated_at'))
                    ->date()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('type')
                    ->label(__('sekaya_value.type'))
                    ->options([
                        SekayaValue::TYPE_ORDER_IMPACT_REASONS => __('sekaya_value.development_impact'),
                        SekayaValue::TYPE_PERFORMANCE_CARD_PRODUCT => __('sekaya_value.products'),
                    ])
                    ->placeholder(__('sekaya_value.all_types')),
            ])
            ->actions([
                Tables\Actions\ActionGroup::make([
                    Tables\Actions\ViewAction::make(),
                    Tables\Actions\EditAction::make(),
                    Tables\Actions\DeleteAction::make(),
                ]),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ])
            ->defaultSort('created_at', 'desc')
            ->paginated([10, 25, 50, 100]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListSekayaValues::route('/'),
            'create' => Pages\CreateSekayaValue::route('/create'),
            'view' => Pages\ViewSekayaValue::route('/{record}'),
            'edit' => Pages\EditSekayaValue::route('/{record}/edit'),
        ];
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view',
            'view_any',
            'create',
            'update',
            'restore',
            'restore_any',
            'replicate',
            'reorder',
            'delete',
            'delete_any',
            'force_delete',
            'force_delete_any',
        ];
    }
}
