<?php

namespace App\Filament\Resources\RoleResource\Api\Handlers;

use App\Filament\Resources\RoleResource;
use App\Filament\Resources\RoleResource\Api\Requests\UpdateRoleRequest;
use Rupadana\ApiService\Http\Handlers;

class UpdateHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = RoleResource::class;

    public static function getMethod()
    {
        return Handlers::PUT;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Update Role
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(UpdateRoleRequest $request)
    {
        $id = $request->route('id');

        $model = static::getModel()::find($id);

        if (! $model) {
            return static::sendNotFoundResponse();
        }

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Update Resource');
    }
}
