<?php

namespace App\Filament\Resources\RoleResource\Api\Handlers;

use App\Filament\Resources\RoleResource;
use App\Filament\Resources\RoleResource\Api\Transformers\RoleTransformer;
use Illuminate\Http\Request;
use Rupadana\ApiService\Http\Handlers;
use Spatie\QueryBuilder\QueryBuilder;

class DetailHandler extends Handlers
{
    public static ?string $uri = '/{id}';

    public static ?string $resource = RoleResource::class;

    /**
     * Show Role
     *
     * @return RoleTransformer
     */
    public function handler(Request $request)
    {
        $id = $request->route('id');

        $query = static::getEloquentQuery();

        $query = QueryBuilder::for(
            $query->where(static::getKeyName(), $id)
        )
            ->first();

        if (! $query) {
            return static::sendNotFoundResponse();
        }

        return new RoleTransformer($query);
    }
}
