<?php

namespace App\Filament\Resources\RoleResource\Api\Handlers;

use App\Filament\Resources\RoleResource;
use App\Filament\Resources\RoleResource\Api\Requests\CreateRoleRequest;
use Rupadana\ApiService\Http\Handlers;

class CreateHandler extends Handlers
{
    public static ?string $uri = '/';

    public static ?string $resource = RoleResource::class;

    public static function getMethod()
    {
        return Handlers::POST;
    }

    public static function getModel()
    {
        return static::$resource::getModel();
    }

    /**
     * Create Role
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function handler(CreateRoleRequest $request)
    {
        $model = new (static::getModel());

        $model->fill($request->all());

        $model->save();

        return static::sendSuccessResponse($model, 'Successfully Create Resource');
    }
}
